/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.dialog.comp.UDFPasswordFieldWithRestriction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.util.BlockByNumberComparator;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class EditUDFParameterPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    protected LogoDrawingUDF logoDrawing;
    JTabbedPane jTabPanel = null;
    List<ItemInfo> parameterItemList = new ArrayList<ItemInfo>();
    JButton insertParameterItemButton;
    JButton removeParameterItemButton;
    JTable udfParamTable = null;
    JTable inputTable = null;
    JTable outputTable = null;
    JTextField idText = null;
    JLabel oldPasswordLabel = null;
    JLabel newPasswordLabel = null;
    JLabel repeatPasswordLabel = null;
    UDFPasswordFieldWithRestriction oldPasswordField = null;
    UDFPasswordFieldWithRestriction newPasswordField = null;
    UDFPasswordFieldWithRestriction repeatPasswordField = null;
    NameEditor nameEdittor = new NameEditor(4);
    JTextArea commentTextArea = new JTextArea();
    BorderJPanel blockListPanel;
    JList blockJList;
    BorderJPanel parameterListPanel;
    JList parameterItemJList;
    Vector concreteParameterItems;

    public EditUDFParameterPanel(LogoDrawingUDF logoDrawing) {
        this.logoDrawing = logoDrawing;
        this.initialize();
    }

    public void setLabels() {
    }

    public void storeFieldContents() {
        if (this.checkChanged()) {
            this.logoDrawing.setModified(true);
        }
        UDFBlock udfBlock = ((WiringDiagramUDF)this.logoDrawing.getWiringDiagram()).getUDFBlock();
        udfBlock.getParameter().getParameterItems().clear();
        for (ItemInfo info : this.parameterItemList) {
            if (info.name == null || info.block == null || info.item.getIdentifier() == null) continue;
            ((UDFBlockParameter)udfBlock.getParameter()).addItem(info.name, info.block, info.item.getIdentifier());
        }
        this.setConnetorName();
        udfBlock.setIdentifier(this.idText.getText());
        udfBlock.setComment(this.commentTextArea.getText());
        this.logoDrawing.getUDFCommentTextFigure().setText(this.commentTextArea.getText());
        if (this.oldPasswordField.checkChanged() || this.newPasswordField.checkChanged()) {
            udfBlock.setPassword(this.newPasswordField.getText());
        }
    }

    public boolean checkChanged() {
        int i;
        IoTableModel model;
        WiringDiagramUDF wiringdiagram;
        UDFBlock udfBlock;
        if (this.inputTable.isEditing()) {
            this.inputTable.getCellEditor().stopCellEditing();
        }
        if (this.outputTable.isEditing()) {
            this.outputTable.getCellEditor().stopCellEditing();
        }
        if (this.udfParamTable.isEditing()) {
            this.udfParamTable.getCellEditor().stopCellEditing();
        }
        if (!Util.isObjectEqual((udfBlock = (wiringdiagram = (WiringDiagramUDF)this.logoDrawing.getWiringDiagram()).getUDFBlock()).getIdentifier(), this.idText.getText())) {
            return true;
        }
        if (!Util.isObjectEqual(udfBlock.getPassword(), this.newPasswordField.getText())) {
            return true;
        }
        if (!Util.isObjectEqual(udfBlock.getComment(), this.commentTextArea.getText())) {
            return true;
        }
        if (this.inputTable != null) {
            Vector<Block> inputs = wiringdiagram.getInConnectorBlocks();
            model = (IoTableModel)this.inputTable.getModel();
            for (i = 0; i < this.inputTable.getModel().getRowCount(); ++i) {
                if (Util.isObjectEqual(inputs.get(i).getUserDefinedName(), model.getValueAt(i, 2))) continue;
                return true;
            }
        }
        if (this.outputTable != null) {
            Vector<Block> outputs = wiringdiagram.getOutConnectorBlocks();
            model = (IoTableModel)this.outputTable.getModel();
            for (i = 0; i < this.outputTable.getModel().getRowCount(); ++i) {
                if (Util.isObjectEqual(outputs.get(i).getUserDefinedName(), model.getValueAt(i, 2))) continue;
                return true;
            }
        }
        if (!(udfBlock.getParameter().getParameterItems() == null && this.parameterItemList == null || udfBlock.getParameter().getParameterItems() == null && this.parameterItemList.size() == 0 || udfBlock.getParameter().getParameterItems().size() == 0 && this.parameterItemList == null || udfBlock.getParameter().getParameterItems().size() == 0 && this.parameterItemList.size() == 0)) {
            if (udfBlock.getParameter().getParameterItems() == null && this.parameterItemList.size() > 0 || udfBlock.getParameter().getParameterItems().size() > 0 && this.parameterItemList == null || udfBlock.getParameter().getParameterItems().size() != this.parameterItemList.size()) {
                return true;
            }
            for (int i2 = 0; i2 < this.parameterItemList.size(); ++i2) {
                ItemInfo info = this.parameterItemList.get(i2);
                UDFParameterItem item = (UDFParameterItem)udfBlock.getParameter().getParameterItems().get(i2);
                if (Util.isObjectEqual(item.getIdentifier(), info.name) && Util.isObjectEqual(info.block.getParameter().getParameterItem(info.item.getIdentifier()), item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkFieldContents() {
        if (this.idText.getText() == null || this.idText.getText().equals("")) {
            new LogoError(null, "dialog.parameter.editudf.emptyUDFIdentifier", "The \"Identifier\" field must not be empty.", 0, 0).display();
            return false;
        }
        UDFBlock udfBlock = ((WiringDiagramUDF)this.logoDrawing.getWiringDiagram()).getUDFBlock();
        if (this.oldPasswordField.checkChanged() || this.newPasswordField.checkChanged() || this.repeatPasswordField.checkChanged()) {
            if (!Util.isObjectEqual(this.oldPasswordField.getText(), udfBlock.getPassword())) {
                new LogoError(null, "dialog.password.wrongOldPassword", "The old password is incorrect.", 0, 0).display();
                return false;
            }
            if (!Util.isObjectEqual(this.newPasswordField.getText(), this.repeatPasswordField.getText())) {
                new LogoError(null, "dialog.password.wrongNewPassword", "The new passwords are not identical", 0, 0).display();
                return false;
            }
        }
        for (int i = 0; i < this.parameterItemList.size(); ++i) {
            ItemInfo info = this.parameterItemList.get(i);
            String name = info.name;
            if (Util.isEmptyString(name)) {
                Object[] additionalInformation = new Object[]{i + 1};
                this.udfParamTable.getSelectionModel().clearSelection();
                this.udfParamTable.getSelectionModel().addSelectionInterval(i, i);
                new LogoError(null, "dialog.parameter.editudf.emptyIdentifier", "The \"Identifier\" field in line " + (i + 1) + " must not be empty.", additionalInformation, 0, 0).display();
                return false;
            }
            for (int j = i + 1; j < this.parameterItemList.size(); ++j) {
                if (!name.equals(this.parameterItemList.get((int)j).name)) continue;
                Object[] additionalInformation = new Object[]{i + 1, j + 1};
                this.udfParamTable.getSelectionModel().clearSelection();
                this.udfParamTable.getSelectionModel().addSelectionInterval(i, i);
                this.udfParamTable.getSelectionModel().addSelectionInterval(j, j);
                new LogoError(null, "dialog.parameter.editudf.sameName", "The \"Identifier\" fields in lines " + (i + 1) + " must not be the same.", additionalInformation, 0, 0).display();
                return false;
            }
        }
        return true;
    }

    private void setConnetorName() {
        int i;
        IoTableModel model;
        WiringDiagramUDF wiringdiagram = (WiringDiagramUDF)this.logoDrawing.getWiringDiagram();
        if (this.inputTable != null) {
            Vector<Block> inputs = wiringdiagram.getInConnectorBlocks();
            model = (IoTableModel)this.inputTable.getModel();
            for (i = 0; i < this.inputTable.getModel().getRowCount(); ++i) {
                inputs.get(i).setUserDefinedName((String)model.getValueAt(i, 2));
            }
        }
        if (this.outputTable != null) {
            Vector<Block> outputs = wiringdiagram.getOutConnectorBlocks();
            model = (IoTableModel)this.outputTable.getModel();
            for (i = 0; i < this.outputTable.getModel().getRowCount(); ++i) {
                outputs.get(i).setUserDefinedName((String)model.getValueAt(i, 2));
            }
        }
    }

    public void loadFieldContents() {
        UDFBlock udfBlock = ((WiringDiagramUDF)this.logoDrawing.getWiringDiagram()).getUDFBlock();
        boolean visible = udfBlock.getPassword().length() > 0;
        this.oldPasswordLabel.setEnabled(visible);
        this.oldPasswordField.setEnabled(visible);
        this.parameterItemList.clear();
        ParameterItemList itemListToLoad = udfBlock.getParameter().getParameterItems();
        for (Object item : itemListToLoad) {
            ParameterItem parameterItem = (ParameterItem)item;
            this.parameterItemList.add(new ItemInfo(parameterItem.getIdentifier(), ((UDFParameterItem)parameterItem).getSourceParameterItem().getParameter().getBlock(), ((UDFParameterItem)parameterItem).getSourceParameterItem()));
        }
        Vector blocks = this.getBlocksForReference();
        Collections.sort(blocks, new BlockByNumberComparator());
        this.blockJList.setListData(blocks);
    }

    private String correctIdentifier(String toCorrect) {
        StringBuffer corrected = new StringBuffer();
        if (toCorrect == null || toCorrect.equals("")) {
            return "null";
        }
        for (int i = 0; i < toCorrect.length(); ++i) {
            String each;
            Pattern pattern = Pattern.compile("[A-Za-z\\d_\\-]");
            Matcher isMatch = pattern.matcher(each = toCorrect.substring(i, i + 1));
            if (!isMatch.matches()) continue;
            corrected.append(each);
        }
        return corrected.toString();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.jTabPanel = new JTabbedPane();
        this.add((Component)this.jTabPanel, "North");
        this.jTabPanel.add((Component)this.getIOPanel(), Language.getString("dialog.parameter.editudf.ioPanelTitle", "I/O"));
        this.jTabPanel.add((Component)this.getUDFParamPanel(), Language.getString("dialog.parameter.editudf.udfParamPanelTitle", "Parameters"));
        this.jTabPanel.add((Component)this.getDescriptionPanel(), Language.getString("dialog.parameter.editudf.udfCommentPanelTitle", "Comment"));
        this.initListeners();
    }

    private JPanel getIOPanel() {
        UDFBlock udfBlock = ((WiringDiagramUDF)this.logoDrawing.getWiringDiagram()).getUDFBlock();
        JPanel panel = new JPanel();
        panel.setName("IO");
        panel.setLayout(new GridBagLayout());
        this.idText = new IdentifierJTexteField(8);
        this.idText.setText(udfBlock.getIdentifier());
        JPanel basicInfoPanel = new JPanel();
        basicInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 10, 0);
        basicInfoPanel.add((Component)new JLabel(Language.getString("dialog.parameter.editudf.labelIdentifier", "Identifier")), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 10, 0);
        basicInfoPanel.add((Component)this.idText, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        basicInfoPanel.add((Component)new JPanel(), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        constraints.insets = new Insets(5, 0, 5, 0);
        basicInfoPanel.add((Component)new JSeparator(), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel.add((Component)basicInfoPanel, constraints);
        this.oldPasswordLabel = new JLabel(Language.getString("dialog.changePassword.oldPassword", "Old password:"));
        this.newPasswordLabel = new JLabel(Language.getString("dialog.changePassword.newPassword", "New password:"));
        this.repeatPasswordLabel = new JLabel(Language.getString("dialog.changePassword.newPassword1", "Repeat new password"));
        this.oldPasswordField = new UDFPasswordFieldWithRestriction(10);
        this.newPasswordField = new UDFPasswordFieldWithRestriction(10);
        this.repeatPasswordField = new UDFPasswordFieldWithRestriction(10);
        Dimension maxDimension = new Dimension(50, this.repeatPasswordField.getHeight());
        Dimension minDimension = new Dimension(20, this.repeatPasswordField.getHeight());
        this.oldPasswordField.setMaximumSize(maxDimension);
        this.newPasswordField.setMaximumSize(maxDimension);
        this.repeatPasswordField.setMaximumSize(maxDimension);
        this.oldPasswordField.setMinimumSize(minDimension);
        this.newPasswordField.setMinimumSize(minDimension);
        this.repeatPasswordField.setMinimumSize(minDimension);
        JPanel pwdPanel = new JPanel();
        pwdPanel.setLayout(new GridLayout(3, 3));
        pwdPanel.setBorder(BorderFactory.createTitledBorder(Language.getString("dialog.parameter.editudf.udfPassword", "UDF password")));
        pwdPanel.add(this.oldPasswordLabel);
        pwdPanel.add(this.oldPasswordField);
        pwdPanel.add(new JLabel());
        pwdPanel.add(this.newPasswordLabel);
        pwdPanel.add(this.newPasswordField);
        pwdPanel.add(new JLabel());
        pwdPanel.add(this.repeatPasswordLabel);
        pwdPanel.add(this.repeatPasswordField);
        pwdPanel.add(new JLabel());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel.add((Component)pwdPanel, constraints);
        this.inputTable = new JTable(new IoTableModel(true));
        this.inputTable.setRowHeight(20);
        this.inputTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.inputTable.getColumnModel().getColumn(1).setMaxWidth(200);
        this.inputTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.outputTable = new JTable(new IoTableModel(false));
        this.outputTable.setRowHeight(20);
        this.outputTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.outputTable.getColumnModel().getColumn(1).setMaxWidth(200);
        this.outputTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JTextField()));
        JScrollPane jspInput = new JScrollPane(this.inputTable);
        jspInput.setBorder(BorderFactory.createTitledBorder(Language.getString("dialog.parameter.editudf.inTableTitle", "Input Connectors")));
        jspInput.setPreferredSize(new Dimension(300, 140));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel.add((Component)jspInput, constraints);
        JScrollPane jspOutput = new JScrollPane(this.outputTable);
        jspOutput.setBorder(BorderFactory.createTitledBorder(Language.getString("dialog.parameter.editudf.outTableTitle", "Output Connectors")));
        jspOutput.setPreferredSize(new Dimension(300, 140));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel.add((Component)jspOutput, constraints);
        return panel;
    }

    private JPanel getUDFParamPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel operPanel = new JPanel();
        operPanel.setName("Parameter");
        operPanel.setLayout(new BoxLayout(operPanel, 0));
        operPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        operPanel.add(Box.createHorizontalStrut(10));
        this.insertParameterItemButton = new JButton(Language.getString("dialog.parameter.editudf.addBtn", "Add"));
        operPanel.add(this.insertParameterItemButton);
        operPanel.add(Box.createHorizontalStrut(20));
        this.removeParameterItemButton = new JButton(Language.getString("dialog.parameter.editudf.removeBtn", "Remove"));
        this.insertParameterItemButton.setEnabled(false);
        operPanel.add(this.removeParameterItemButton);
        this.udfParamTable = new JTable(new UDFTableModel());
        this.udfParamTable.setRowHeight(20);
        JScrollPane jsp = new JScrollPane(this.udfParamTable);
        jsp.setPreferredSize(new Dimension(300, 230));
        jsp.setBorder(BorderFactory.createTitledBorder(Language.getString("dialog.parameter.editudf.udfParamTableTitle", "Parameter Reference")));
        this.udfParamTable.setShowGrid(true);
        this.udfParamTable.setSelectionMode(2);
        this.udfParamTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.udfParamTable.getColumnModel().getColumn(0).setCellEditor(this.nameEdittor);
        this.udfParamTable.getColumnModel().getColumn(1).setCellRenderer(new BlockTableCellRender());
        this.udfParamTable.getColumnModel().getColumn(2).setCellRenderer(new ParameterTableCellRender());
        panel.add((Component)jsp, "North");
        panel.add((Component)operPanel, "Center");
        JPanel allParamListPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 20.0;
        gbc.insets.bottom = 3;
        allParamListPanel.add((Component)this.getBlockListPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 20.0;
        gbc.insets.bottom = 3;
        allParamListPanel.add((Component)this.getParameterListPanel(), gbc);
        panel.add((Component)allParamListPanel, "South");
        return panel;
    }

    public Vector getBlocksForReference() {
        WiringDiagram wd = this.logoDrawing.getWiringDiagram();
        Enumeration blockEnum = wd.getBlocks().elements();
        Vector<Block> blocks = new Vector<Block>();
        while (blockEnum.hasMoreElements()) {
            BlockParameter blockParameter;
            Block block = (Block)blockEnum.nextElement();
            if (wd.getMacroBlock(block) != null || (blockParameter = block.getParameter()) == null || blockParameter.getParameterItems().getPublicParameterItemList().isEmpty()) continue;
            blocks.addElement(block);
        }
        return blocks;
    }

    private JPanel getDescriptionPanel() {
        UDFBlock udfBlock = ((WiringDiagramUDF)this.logoDrawing.getWiringDiagram()).getUDFBlock();
        JPanel panel = new JPanel();
        panel.setName("Description");
        panel.setLayout(new BorderLayout());
        this.commentTextArea.setText(udfBlock.getComment());
        JScrollPane jsp = new JScrollPane(this.commentTextArea);
        panel.add((Component)jsp, "Center");
        return panel;
    }

    private JPanel getParameterListPanel() {
        this.parameterListPanel = new BorderJPanel(new BorderLayout());
        this.parameterListPanel.setTitle(Language.getString("dialog.parameter.editudf.blockParameterBorder", "Parameter"));
        this.parameterItemJList = new JList();
        ParameterItemListCellRenderer parameterItemListCellRenderer = new ParameterItemListCellRenderer();
        parameterItemListCellRenderer.setHorizontalTextPosition(10);
        this.parameterItemJList.setCellRenderer(parameterItemListCellRenderer);
        this.parameterItemJList.setSelectionMode(0);
        this.parameterListPanel.add((Component)new JScrollPane(this.parameterItemJList), "Center");
        this.parameterListPanel.setPreferredSize(new Dimension(300, 170));
        return this.parameterListPanel;
    }

    private JPanel getBlockListPanel() {
        this.blockListPanel = new BorderJPanel(new BorderLayout());
        this.blockListPanel.setTitle(Language.getString("dialog.parameter.editudf.blockBorder", "Block"));
        this.blockJList = new JList();
        this.blockJList.setSelectionMode(0);
        this.blockJList.setCellRenderer(new BlockListCellRenderer(true));
        this.blockListPanel.add(new JScrollPane(this.blockJList));
        this.blockListPanel.setPreferredSize(new Dimension(300, 170));
        return this.blockListPanel;
    }

    protected void fillParameterList() {
        Block block = (Block)this.blockJList.getSelectedValue();
        if (block == null) {
            return;
        }
        BlockParameter blockParameter = block.getParameter();
        this.concreteParameterItems = new Vector();
        for (ParameterItem parameterItem : blockParameter.getParameterItems().getPublicToUDFParameterItemList().instance(blockParameter)) {
            boolean insertFlg = true;
            for (int i = 0; i < this.parameterItemList.size(); ++i) {
                if (!parameterItem.equals(this.parameterItemList.get((int)i).item)) continue;
                insertFlg = false;
                break;
            }
            if (!insertFlg) continue;
            this.concreteParameterItems.add(parameterItem);
        }
        this.parameterItemJList.setListData(this.concreteParameterItems);
    }

    protected void insertParameterItem() {
        ParameterItem parameterItem = null;
        if (this.parameterItemJList.getSelectedValue() != null) {
            parameterItem = (ParameterItem)this.parameterItemJList.getSelectedValue();
        }
        if (parameterItem == null) {
            return;
        }
        this.parameterItemList.add(new ItemInfo(this.correctIdentifier(parameterItem.getIdentifier()), parameterItem.getParameter().getBlock(), parameterItem));
        this.udfParamTable.updateUI();
        if (this.parameterItemList != null && this.parameterItemList.size() >= this.logoDrawing.getWiringDiagram().getHardware().getIntProperty("maxUDFParameter")) {
            this.insertParameterItemButton.setEnabled(false);
        }
        this.fillParameterList();
    }

    private void initListeners() {
        this.blockJList.addListSelectionListener(new BlockListSelectionListener());
        this.parameterItemJList.addListSelectionListener(new ParameterItemSelectionListener());
        MouseAdapter doubleClickListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && (EditUDFParameterPanel.this.parameterItemList == null || EditUDFParameterPanel.this.parameterItemList.size() < EditUDFParameterPanel.this.logoDrawing.getWiringDiagram().getHardware().getIntProperty("maxUDFParameter"))) {
                    EditUDFParameterPanel.this.insertParameterItem();
                }
            }
        };
        this.parameterItemJList.addMouseListener(doubleClickListener);
        this.insertParameterItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditUDFParameterPanel.this.insertParameterItem();
            }
        });
        this.removeParameterItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditUDFParameterPanel.this.udfParamTable.isEditing()) {
                    EditUDFParameterPanel.this.udfParamTable.getCellEditor().cancelCellEditing();
                }
                if (EditUDFParameterPanel.this.parameterItemList == null || EditUDFParameterPanel.this.parameterItemList.size() == 0) {
                    return;
                }
                int[] deleted = EditUDFParameterPanel.this.udfParamTable.getSelectedRows();
                for (int i = deleted.length - 1; i >= 0 && deleted[i] < EditUDFParameterPanel.this.parameterItemList.size(); --i) {
                    EditUDFParameterPanel.this.parameterItemList.remove(deleted[i]);
                }
                EditUDFParameterPanel.this.udfParamTable.repaint();
                EditUDFParameterPanel.this.fillParameterList();
            }
        });
    }

    private Icon getParamIcon(ParameterItem parameterItem) {
        ImageIcon icon = null;
        if (parameterItem.getParameterValueType() == 1 && !parameterItem.isEditable()) {
            icon = Global.getIcon("Refresh.gif");
        }
        if (parameterItem.getParameterValueType() == 1 && parameterItem.isEditable()) {
            icon = Global.getIcon("RefreshEditable.gif");
        }
        if (parameterItem.getParameterValueType() != 1 && parameterItem.isEditable()) {
            icon = Global.getIcon("Editable.gif");
        }
        if (parameterItem.getParameterValueType() == 2) {
            icon = Global.getIcon("Refresh.gif");
        }
        return icon;
    }

    public String getHelpIdString() {
        Component comp = this.jTabPanel.getSelectedComponent();
        String result = "dialog.editUDFParameter." + comp.getName();
        return result;
    }

    public class IdentifierJTexteField
    extends LengthRestrictedJTextField {
        private static final long serialVersionUID = 1L;

        public IdentifierJTexteField(int nrOfColumns) {
            super(nrOfColumns);
        }

        public boolean isValidString(String str) {
            if (!super.isValidString(str)) {
                return false;
            }
            Pattern pattern = Pattern.compile("[\\w\\-\\.\\(\\)\\#]{1," + this.maxLength + "}");
            Matcher isMatch = pattern.matcher(str);
            return isMatch.matches();
        }
    }

    private class ParameterItemListCellRenderer
    extends DefaultListCellRenderer {
        private ParameterItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            ParameterItem parameterItem = (ParameterItem)value;
            this.setText(parameterItem.getLocalisedName());
            this.setIcon(EditUDFParameterPanel.this.getParamIcon(parameterItem));
            return this;
        }
    }

    protected class ParameterItemSelectionListener
    implements ListSelectionListener {
        protected ParameterItemSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            EditUDFParameterPanel.this.insertParameterItemButton.setEnabled((EditUDFParameterPanel.this.parameterItemList == null || EditUDFParameterPanel.this.parameterItemList.size() < EditUDFParameterPanel.this.logoDrawing.getWiringDiagram().getHardware().getIntProperty("maxUDFParameter")) && ((JList)e.getSource()).getSelectedValue() != null);
        }
    }

    protected class BlockListSelectionListener
    implements ListSelectionListener {
        protected BlockListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (EditUDFParameterPanel.this.blockJList.getSelectedIndex() != -1) {
                EditUDFParameterPanel.this.fillParameterList();
            }
        }
    }

    class ItemInfo {
        String name;
        Block block;
        ParameterItem item;

        public ItemInfo() {
        }

        public ItemInfo(String name, Block block, ParameterItem item) {
            if (name != null && name.length() > EditUDFParameterPanel.this.nameEdittor.getMaxLength()) {
                name = name.substring(0, EditUDFParameterPanel.this.nameEdittor.getMaxLength());
            }
            this.name = block instanceof ComfortSwitchBlock && item.getIdentifier().equals("TH") ? "T" : name;
            this.block = block;
            this.item = item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IoTableModel
    extends AbstractTableModel {
        List<String> names;
        String[] columnNames = new String[]{Language.getString("dialog.parameter.editudf.ioColIndex", "Index"), Language.getString("dialog.parameter.editudf.ioColIdentifier", "Identifier"), Language.getString("dialog.parameter.editudf.ioColName", "Name")};
        boolean isInput;

        public IoTableModel(boolean input) {
            this.names = new ArrayList<String>();
            Vector<Block> blocks = this.getBlockConnectors(input);
            for (int i = 0; i < blocks.size(); ++i) {
                this.names.add(blocks.get(i).getUserDefinedName());
            }
            this.isInput = input;
        }

        private Vector<Block> getBlockConnectors(boolean isInput) {
            WiringDiagramUDF wiring = (WiringDiagramUDF)EditUDFParameterPanel.this.logoDrawing.getWiringDiagram();
            if (isInput) {
                return wiring.getInConnectorBlocks();
            }
            return wiring.getOutConnectorBlocks();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return String.valueOf(rowIndex + 1);
            }
            if (columnIndex == 1) {
                Block block = this.getBlockConnectors(this.isInput).get(rowIndex);
                return "#" + block.getNumberString();
            }
            return this.names.get(rowIndex);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                this.names.set(row, (String)value);
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }
    }

    class UDFTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{Language.getString("dialog.parameter.editudf.paramColIdentifier", "Identifier"), Language.getString("dialog.parameter.editudf.paramColBlock", "Block"), Language.getString("dialog.parameter.editudf.paramColParameter", "Parameter")};

        UDFTableModel() {
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return EditUDFParameterPanel.this.parameterItemList.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ItemInfo info = EditUDFParameterPanel.this.parameterItemList.get(rowIndex);
            if (columnIndex == 0) {
                if (info.name == null) {
                    return "";
                }
                return info.name;
            }
            if (info.item == null) {
                return "";
            }
            if (columnIndex == 1) {
                return info.block;
            }
            return info.item;
        }

        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            if (col == 0) {
                EditUDFParameterPanel.this.parameterItemList.get((int)row).name = value.toString();
            } else if (col == 1) {
                EditUDFParameterPanel.this.parameterItemList.get((int)row).block = (Block)value;
            } else if (col == 2) {
                EditUDFParameterPanel.this.parameterItemList.get((int)row).item = (ParameterItem)value;
            }
            EditUDFParameterPanel.this.udfParamTable.repaint();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    class NameEditor
    extends DefaultCellEditor {
        int row;
        int maxLength;

        public NameEditor(int maxLength) {
            super(new IdentifierJTexteField(maxLength));
            this.row = -1;
            this.setMaxLength(maxLength);
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            JTextField ftf = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ftf.setText(value.toString());
            return ftf;
        }

        public Object getCellEditorValue() {
            return ((JTextField)this.getComponent()).getText();
        }
    }

    private class ParameterTableCellRender
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = ((ParameterItem)value).getLocalisedName();
            this.setText(text);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setIcon(EditUDFParameterPanel.this.getParamIcon((ParameterItem)value));
            this.setHorizontalTextPosition(2);
            return this;
        }
    }

    private class BlockTableCellRender
    extends DefaultTableCellRenderer {
        protected float scale = 0.5f;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = ((Block)value).getLocalizedName(true);
            this.setText(text);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setIcon(this.scaleIcon(Global.getIcon(((Block)value).getIconName())));
            return this;
        }

        protected Icon scaleIcon(ImageIcon orgIcon) {
            float scale = this.getScale();
            if (scale == 0.5f) {
                return new ImageIcon(orgIcon.getImage().getScaledInstance((int)((float)orgIcon.getIconWidth() * scale), (int)((float)orgIcon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
            }
            return orgIcon;
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }
    }
}

